<?xml version="1.0"?>
<xsl:stylesheet>
<xsl:output method="html" indent="no"/>
<xsl:include href="movieCommon.xsl"/>

<!-- Parameters for assigning a unique names to the graphical elements
	on the page. These can be set from Java in XSLTProcessor object.
-->
<xsl:param name="movieNum" select="'default'"/>
<xsl:param name="aveRating" select="'2.5'"/>
<xsl:param name="movieArtRoot" select="'cover_art'"/>
<xsl:param name="productPage" select="'default'"/>
<xsl:param name="itemIDParam" select="'default'"/>
<xsl:param name="itemID"  select="'default'"/>
<xsl:param name="predRatingParam" select="'default'"/>
<xsl:param name="predRating" select="'defualt'"/>
<xsl:param name="addMyListParam" select="'default'"/>
	

<xsl:template name="productURL">
	<xsl:value-of select="$productPage"/>?<xsl:value-of select="$itemIDParam"/>=<xsl:value-of select="$itemID"/>&amp;<xsl:value-of select="$predRatingParam"/>=<xsl:value-of select="$predRating"/>
</xsl:template>

<!--	Template for document root. Prevents the regurgitation of bad XML
-->
<xsl:template match="/">
	<xsl:apply-templates select="MOVIE"/>
</xsl:template>

<!-- Template for the movie: outputs a single table element
	(<td>) for inclusion in a table of movie recommendations.
-->
<xsl:template match="/MOVIE">
	<xsl:param name="prodURL">
		<xsl:call-template name="productURL"/>
	</xsl:param>
		<td id="wtback" valign="top" width="296" height="177"> <!--Start movie ratings table  w=297--> 
			<table border="0" cellspacing="0" cellpadding="0" width="287">
			<tr>
				<td width="89" height="128" valign="top"> 
					<table width="89" border="0" cellspacing="0" cellpadding="0">
					<tr> 
						<td id="greenback">
							<span id="smalltext">&#160;add to my list 
								<input type="checkbox">
									<xsl:attribute name="name"><xsl:value-of select="$addMyListParam"/></xsl:attribute>
									<xsl:attribute name="value"><xsl:value-of select="$itemID"/></xsl:attribute>
								</input>
							</span>
						</td>
					</tr>
					</table>
					<!-- Movie Art -->
					<a id="movieLink">
						<xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute>
						<xsl:call-template name="movieArt">
							<xsl:with-param name="height" select="'121'"/>
							<xsl:with-param name="root" select="."/>
							<xsl:with-param name="altText">Go to this movie's product page!</xsl:with-param>
						</xsl:call-template>
					</a>
				<br/>
				</td>
				<!-- Display long movie name -->
				<td width="197" valign="top" height="127">
					<span id="normaltext">
					<a id="movieLink" alt="Go to this movie's Product Page!"><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute>
					<b>	<xsl:value-of select="TITLES/TITLES_ITEM/TITLE"/> (<xsl:value-of select="ORIGRELEASEYEAR"/>) <xsl:value-of select="RELEASES/RELEASES_ITEM/RATINGTEXT"/>
					</b></a></span>
				<!--Start ratings  table w=190--> 
					<table width="190" border="0" cellspacing="0" cellpadding="0">
					<tr valign="top"> 
						<td width="63" height="50"><img src="images/seenitrateit.gif" width="62" height="51"/></td>
						<td width="127" valign="top" align="left" height="51"> 
							<table width="126" border="0" cellspacing="0" cellpadding="0">
							<tr valign="top" align="left"> 
								<!-- rating title -->
								<td height="13" width="126">
									<img name="title" src="images/spacer.gif" width="126" height="13" border="0" alt="">
										<xsl:attribute name="name">title<xsl:value-of select="$movieNum"/></xsl:attribute>
									</img>
								</td>
							</tr>
							<tr valign="top" align="left"> 
								<!-- rating 'iguy' image -->
								<td height="21" width="126"> 
									<img src="images/iguy_null.gif" width="95" height="21" border="0" alt="iiiiii" >
										<xsl:attribute name="name">iguy<xsl:value-of select="$movieNum"/></xsl:attribute>
										<xsl:attribute name="usemap">#predicted<xsl:value-of select="$movieNum"/></xsl:attribute>
									</img>
								</td>
							</tr>
							<tr valign="top" align="left">
								<!-- line image for predicted rating -->
								<td height="4" width="126">
									<img src="images/spacer.gif" width="95" height="6" border="0" alt="">
										<xsl:attribute name="name">line<xsl:value-of select="$movieNum"/></xsl:attribute>
									</img>
								</td>
							</tr>
							</table><!--End iguys table w=126-->
						</td>
					</tr>
					<tr valign="top"> 
						<!-- average rating -->
						<td colspan="2" height="9"><span id="smalltext"><b>Average Rating : </b><xsl:value-of select="$aveRating"/></span></td>
					</tr>
					<tr valign="top"> 
						<!-- solicit interest -->
						<td colspan="2" height="29"><span id="normaltext"><b>Haven't seen it? Want to?<br/>
							&#160;
								<img name="button" src="images/want_null.gif" width="153" height="15" border="0" alt="want">
									<xsl:attribute name="name">button<xsl:value-of select="$movieNum"/></xsl:attribute>
									<xsl:attribute name="usemap">#radiobutton<xsl:value-of select="$movieNum"/></xsl:attribute>
								</img>
							</b></span>
						</td>
					</tr>
					</table><!--End ratings  table w=190-->
				</td>
			</tr>
			<tr> 
				<td colspan="2" height="20" valign="top">
					<span id="movieDesc">
						<xsl:variable name="moviedesc">
							<xsl:apply-templates select="//NOTES" mode="movieDescription"/>
						</xsl:variable>
						<xsl:value-of select="substring($moviedesc,0,100)"/>...
					<b><a id="movieLink"><xsl:attribute name="href"><xsl:value-of select="$prodURL"/></xsl:attribute><span id="tinytext">read more&gt;&gt;</span></a></b>
					</span>
				</td>
			</tr>
			</table>
		</td>
</xsl:template>

</xsl:stylesheet>


